<?php
// contractc.php - Form submission handler

// Set recipient email
$to = 'carolyn.nelson@davidsonwealthteam.com';

// Get form data
$full_name = isset($_POST['full-name']) ? htmlspecialchars($_POST['full-name']) : '';
$date = isset($_POST['date']) ? htmlspecialchars($_POST['date']) : '';
$agreement_status = isset($_POST['agreement-status']) ? htmlspecialchars($_POST['agreement-status']) : 'false';

// Validate required fields
if (empty($full_name) || empty($date) || $agreement_status !== 'true') {
    die('Error: Required fields are missing or agreement not accepted.');
}

// Prepare email subject and message
$subject = 'Investment Advisory Agreement Submission - ' . $full_name;
$message = "
<html>
<head>
    <title>Investment Advisory Agreement Submission</title>
    <style>
        body { font-family: Arial, sans-serif; line-height: 1.6; }
        .header { background-color: #f4f4f4; padding: 20px; text-align: center; }
        .content { padding: 20px; }
        .footer { background-color: #f4f4f4; padding: 10px; text-align: center; font-size: 0.9em; }
        table { width: 100%; border-collapse: collapse; margin: 20px 0; }
        table, th, td { border: 1px solid #ddd; }
        th, td { padding: 12px; text-align: left; }
        th { background-color: #f4f4f4; }
    </style>
</head>
<body>
    <div class='header'>
        <h2>Investment Advisory Agreement Submission</h2>
    </div>
    <div class='content'>
        <p>A new client has submitted the Investment Advisory Agreement:</p>
        
        <table>
            <tr>
                <th>Client Name</th>
                <td>$full_name</td>
            </tr>
            <tr>
                <th>Submission Date</th>
                <td>$date</td>
            </tr>
            <tr>
                <th>Agreement Status</th>
                <td>Accepted</td>
            </tr>
        </table>
        
        <p>This email confirms that $full_name has accepted the terms of the Investment Advisory Agreement on $date.</p>
    </div>
    <div class='footer'>
        <p>This is an automated message. Please do not reply directly to this email.</p>
    </div>
</body>
</html>
";

// Set email headers
$headers = "MIME-Version: 1.0\r\n";
$headers .= "Content-type: text/html; charset=UTF-8\r\n";
$headers .= "From: $full_name <noreply@davidsonwealthteam.com>\r\n";
$headers .= "Reply-To: $full_name <noreply@davidsonwealthteam.com>\r\n";
$headers .= "X-Mailer: PHP/" . phpversion();

// Send the email
$mail_sent = mail($to, $subject, $message, $headers);

// Log the submission (optional)
$log_entry = date('Y-m-d H:i:s') . " - $full_name submitted the agreement. Email sent: " . ($mail_sent ? 'Yes' : 'No') . "\n";
file_put_contents('agreement_submissions.log', $log_entry, FILE_APPEND);

// Redirect to confirmation page
header('Location: https://www.davidsonwealthteam.com/login-pr-lllllIIII7hj9m-ffnhnjfk=ree-cnhvj.html');
exit();
?>