<?php
// online.php - Live Visitor Counter Backend
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST');
header('Access-Control-Allow-Headers: Content-Type');

// Function to generate realistic visitor count
function generateVisitorCount() {
    $hour = date('H');
    $minute = date('i');
    $day = date('w'); // 0 = Sunday, 6 = Saturday
    $isWeekend = ($day === 0 || $day === 6);
    
    // Base counts based on time of day
    if ($hour >= 0 && $hour < 6) $baseCount = rand(1200, 2500);
    elseif ($hour >= 6 && $hour < 9) $baseCount = rand(1500, 3000);
    elseif ($hour >= 9 && $hour < 12) $baseCount = rand(2000, 4500);
    elseif ($hour >= 12 && $hour < 14) $baseCount = rand(1800, 3500);
    elseif ($hour >= 14 && $hour < 18) $baseCount = rand(2500, 5000);
    elseif ($hour >= 18 && $hour < 22) $baseCount = rand(3000, 6000);
    else $baseCount = rand(1500, 2800);
    
    // Weekend adjustment
    if ($isWeekend) $baseCount = floor($baseCount * 0.7);
    
    // Add realistic fluctuations based on minutes
    $minuteWave = sin($minute * 0.1047) * 400; // 0.1047 = 2*PI/60
    $finalCount = max(1000, min(8000, floor($baseCount + $minuteWave)));
    
    // Format like OJAds
    if ($finalCount >= 10000) {
        $displayCount = ($finalCount / 1000) . 'k+';
    } elseif ($finalCount >= 1000) {
        $displayCount = number_format($finalCount / 1000, 1) . 'k+';
    } else {
        $displayCount = $finalCount . '+';
    }
    
    return $displayCount;
}

// Function to generate trend message
function generateTrendMessage() {
    $trends = [
        'in the last 5 mins',
        'active now',
        'live trading',
        'in session',
        'recently',
        'currently online',
        'just now',
        'trading live'
    ];
    return $trends[array_rand($trends)];
}

// Generate response
$response = [
    'success' => true,
    'display_count' => generateVisitorCount(),
    'trend_message' => generateTrendMessage(),
    'timestamp' => time(),
    'server_time' => date('Y-m-d H:i:s')
];

echo json_encode($response);
exit;
?>