<?php
// contact.php - Simple PHP script to handle form submission

// Set content-type header to JSON
header('Content-Type: application/json');

// Check if the form is submitted using POST
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Collect form data
    $name = isset($_POST['name']) ? trim($_POST['name']) : '';
    $email = isset($_POST['email']) ? trim($_POST['email']) : '';
    $service = isset($_POST['service']) ? trim($_POST['service']) : '';
    $message = isset($_POST['message']) ? trim($_POST['message']) : '';

    // Validate required fields
    if (empty($name) || empty($email) || empty($message)) {
        echo json_encode([
            'status' => 'error',
            'message' => 'Please fill in all required fields.'
        ]);
        exit;
    }

    // Email recipient (adjust to your preferred email address)
    $to = 'samanthahodgemayfield@voyawealthpartners.com';  // Replace with samantha's email address
    $subject = 'New Contact Form Submission';
    
    // Construct email content
    $email_content = "You have received a new message from the contact form:\n\n";
    $email_content .= "Name: $name\n";
    $email_content .= "Email: $email\n";
    $email_content .= "Service Needed: $service\n\n";
    $email_content .= "Message:\n$message\n";
     
    // Set email headers
    $headers = "From: $email\r\n";
    $headers .= "Reply-To: $email\r\n";
    $headers .= "Content-Type: text/plain; charset=UTF-8\r\n";
    
    // Send email
    if (mail($to, $subject, $email_content, $headers)) {
        echo json_encode([
            'status' => 'success',
            'message' => 'Thank you! Your message has been sent. We\'ll respond within 24 hours.'
        ]);
    } else {
        echo json_encode([
            'status' => 'error',
            'message' => 'There was an error sending your message. Please try again.'
        ]);
    }
} else {
    // If the request method is not POST, return an error
    echo json_encode([
        'status' => 'error',
        'message' => 'Invalid request method.'
    ]);
}
?>
