<?php
session_start();

if (!isset($_SESSION['authenticated']) {
    header('Location: login.php');
    exit;
}

// Optional: Verify the specific user should have access to this specific terms page
$current_page = basename($_SERVER['PHP_SELF']);
$allowed_pages = [
    'marten.teppan@gmail.com' => 'terms-marten-teppan.php',
    // Add other user/page mappings
];

if ($allowed_pages[$_SESSION['email']] !== $current_page) {
    header('Location: login.php');
    exit;
}
?>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    
    <style>
        :root {
            --primary-color: #2c3e50;
            --secondary-color: #3498db;
            --accent-color: #4CAF50;
            --text-color: #333;
            --light-gray: #f9f9f9;
            --border-color: #ddd;
            --portfolio-btn-color: #2980b9;
            --core-assets-color: #4CAF50;
            --altcoin-color: #FFA500;
            --defi-color: #9C27B0;
            --cash-color: #2196F3;
        }
        
        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
        }
        
        body {
            font-family: 'Arial', sans-serif;
            line-height: 1.6;
            color: var(--text-color);
            background-color: #fff;
            padding: 0;
            margin: 0;
        }
        
        .container {
            width: 100%;
            max-width: 1200px;
            margin: 0 auto;
            padding: 20px;
        }
        
        h1, h2, h3, h4 {
            color: var(--primary-color);
            margin-bottom: 1rem;
        }
        
        h1 {
            font-size: 2rem;
            text-align: center;
            margin: 1.5rem 0;
            padding-bottom: 1rem;
            border-bottom: 1px solid var(--border-color);
        }
        
        h2 {
            font-size: 1.5rem;
            margin-top: 2rem;
            padding-bottom: 0.5rem;
            border-bottom: 1px solid var(--border-color);
        }
        
        p, li {
            margin-bottom: 1rem;
            font-size: 1rem;
        }
        
        .header {
            text-align: center;
            margin-bottom: 2rem;
        }
        
        .client-info {
            background-color: var(--light-gray);
            padding: 1.5rem;
            border-radius: 8px;
            margin-bottom: 2rem;
            border: 1px solid var(--border-color);
        }
        
        .info-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 1rem;
            margin-top: 1rem;
        }
        
        .info-item strong {
            display: block;
            color: var(--primary-color);
            margin-bottom: 0.25rem;
        }
        
        .bold {
            font-weight: bold;
        }
        
        .section {
            margin-bottom: 1.5rem;
        }
        
        ol, ul {
            padding-left: 2rem;
            margin-bottom: 1.5rem;
        }
        
        li {
            margin-bottom: 0.75rem;
        }
        
        .footer {
            margin-top: 3rem;
            padding-top: 1.5rem;
            border-top: 1px solid var(--border-color);
            text-align: center;
            font-size: 0.9rem;
            color: #777;
        }
        
        .agreement-section {
            background-color: var(--light-gray);
            padding: 2rem;
            border-radius: 8px;
            margin-top: 3rem;
            border: 1px solid var(--border-color);
        }
        
        .checkbox-container {
            margin: 1.5rem 0;
            display: flex;
            align-items: center;
        }
        
        .checkbox-label {
            margin-left: 0.75rem;
            font-weight: bold;
        }
        
        .btn {
            display: inline-block;
            padding: 0.75rem 1.5rem;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-size: 1rem;
            text-align: center;
            text-decoration: none;
            transition: background-color 0.3s ease;
        }
        
        .btn-primary {
            background-color: var(--accent-color);
            color: white;
        }
        
        .btn-primary:hover {
            background-color: #45a049;
        }
        
        .btn-primary:disabled {
            background-color: #cccccc;
            cursor: not-allowed;
        }
        
        /* Form Styles */
        .form-group {
            margin-bottom: 1.25rem;
        }
        
        .form-label {
            display: block;
            margin-bottom: 0.5rem;
            font-weight: bold;
        }
        
        .form-control {
            width: 100%;
            padding: 0.75rem;
            border: 1px solid var(--border-color);
            border-radius: 4px;
            font-size: 1rem;
        }
        
        /* Portfolio Button Styles */
        .portfolio-btn-container {
            text-align: center;
            margin: 2rem 0;
        }
        
        .btn-portfolio {
            background-color: var(--portfolio-btn-color);
            color: white;
        }
        
        .btn-portfolio:hover {
            background-color: #2472a4;
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }
        
        /* Portfolio Section Styles */
        .portfolio-section {
            display: none;
            margin-top: 2rem;
            animation: fadeIn 0.5s ease-in-out;
        }
        
        @keyframes fadeIn {
            from { opacity: 0; }
            to { opacity: 1; }
        }
        
        .portfolio-summary {
            background-color: var(--light-gray);
            padding: 1.5rem;
            border-radius: 8px;
            margin-bottom: 2rem;
            border: 1px solid var(--border-color);
        }
        
        .summary-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 1rem;
            margin-top: 1rem;
        }
        
        .summary-item strong {
            display: block;
            color: var(--primary-color);
            margin-bottom: 0.25rem;
        }
        
        .allocation-table {
            width: 100%;
            border-collapse: collapse;
            margin: 1.5rem 0;
        }
        
        .allocation-table th, 
        .allocation-table td {
            border: 1px solid var(--border-color);
            padding: 0.75rem;
            text-align: left;
        }
        
        .allocation-table th {
            background-color: #f2f2f2;
            font-weight: bold;
        }
        
        .allocation-table tr:nth-child(even) {
            background-color: var(--light-gray);
        }
        
        .strategy-notes {
            margin: 2rem 0;
        }
        
        .strategy-category {
            margin-bottom: 2rem;
        }
        
        .strategy-category h3 {
            color: var(--accent-color);
            margin-bottom: 0.5rem;
            display: flex;
            align-items: center;
        }
        
        .strategy-category h3::before {
            content: "";
            display: inline-block;
            width: 12px;
            height: 12px;
            border-radius: 50%;
            margin-right: 8px;
        }
        
        .core-assets h3::before {
            background-color: var(--core-assets-color);
        }
        
        .altcoin h3::before {
            background-color: var(--altcoin-color);
        }
        
        .defi h3::before {
            background-color: var(--defi-color);
        }
        
        .cash h3::before {
            background-color: var(--cash-color);
        }
        
        .key-considerations {
            background-color: var(--light-gray);
            padding: 1.5rem;
            border-radius: 8px;
            margin: 2rem 0;
            border-left: 4px solid var(--accent-color);
        }
        
        .allocation-chart {
            display: flex;
            justify-content: center;
            margin: 2.5rem 0;
            flex-wrap: wrap;
        }
        
        .pie-chart {
            width: 300px;
            height: 300px;
            border-radius: 50%;
            background: conic-gradient(
                var(--core-assets-color) 0% 50%,
                var(--altcoin-color) 50% 80%,
                var(--defi-color) 80% 95%,
                var(--cash-color) 95% 100%
            );
        }
        
        .legend {
            display: flex;
            flex-direction: column;
            justify-content: center;
            margin-left: 2rem;
        }
        
        .legend-item {
            display: flex;
            align-items: center;
            margin: 0.5rem 0;
        }
        
        .legend-color {
            width: 20px;
            height: 20px;
            border-radius: 4px;
            margin-right: 0.75rem;
        }
        
        .legend-label {
            font-weight: bold;
            min-width: 150px;
        }
        
        .legend-value {
            margin-left: 0.5rem;
            color: #666;
        }

        /* Responsive Adjustments */
        @media (max-width: 768px) {
            .container {
                padding: 15px;
            }
            
            h1 {
                font-size: 1.6rem;
            }
            
            h2 {
                font-size: 1.3rem;
            }
            
            .agreement-section {
                padding: 1.5rem;
            }
            
            .info-grid {
                grid-template-columns: 1fr;
            }
            
            .allocation-chart {
                flex-direction: column;
                align-items: center;
            }
            
            .pie-chart {
                width: 250px;
                height: 250px;
                margin-bottom: 1.5rem;
            }
            
            .legend {
                margin-left: 0;
            }
        }
        
        @media (max-width: 480px) {
            .container {
                padding: 10px;
            }
            
            h1 {
                font-size: 1.4rem;
            }
            
            h2 {
                font-size: 1.2rem;
            }
            
            ol, ul {
                padding-left: 1.5rem;
            }
            
            .agreement-section {
                padding: 1rem;
            }
            
            .btn {
                padding: 0.6rem 1.2rem;
                font-size: 0.9rem;
            }
            
            .pie-chart {
                width: 200px;
                height: 200px;
            }
            
            .legend-label {
                min-width: 120px;
                font-size: 0.9rem;
            }
            
            .allocation-table {
                display: block; 
                overflow-x: auto;
            }
        }
        
        @media print {
            body {
                font-size: 12pt;
                padding: 0;
            }
            
            .no-print {
                display: none;
            }
            
            .agreement-section, .btn, .portfolio-btn-container, .portfolio-section {
                display: none;
            }
            
            .container {
                max-width: 100%;
                padding: 0.5in;
            }
            
            a {
                text-decoration: none;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            
            <div class="portfolio-btn-container">
                <button class="btn btn-portfolio" id="portfolio-btn">View Portfolio Allocation</button>
            </div>
        </div>

        <div class="portfolio-section" id="portfolio-content">
            <div class="portfolio-summary">
                <h2>Portfolio Summary</h2>
                <div class="summary-grid">
                    <div class="summary-item">
                        <strong>Initial Capital</strong>
                        <span>1,500 USD</span>
                    </div>
                    <div class="summary-item">
                        <strong>Trading Strategy</strong>
                        <span>100% crypto-based high-conviction strategy</span>
                    </div>
                    <div class="summary-item">
                        <strong>Primary Goal</strong>
                        <span>Actively grow capital using a flexible, high-conviction crypto strategy</span>
                    </div>
                </div>
            </div>

            <h2>Portfolio Allocation Overview</h2>
            <table class="allocation-table">
                <thead>
                    <tr>
                        <th>Asset Class</th>
                        <th>Allocation</th>
                        <th>Description</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td>Strategic Core Assets</td>
                        <td>50%</td>
                        <td>A stable allocation across high-conviction, large-cap cryptocurrencies</td>
                    </tr>
                    <tr>
                        <td>Altcoin Rotation</td>
                        <td>30%</td>
                        <td>Actively managed positions in promising mid-cap and emerging tokens</td>
                    </tr>
                    <tr>
                        <td>DeFi/Yield Positions</td>
                        <td>15%</td>
                        <td>Select yield opportunities through staking and DeFi protocols</td>
                    </tr>
                    <tr>
                        <td>USDC Reserve</td>
                        <td>5%</td>
                        <td>Liquidity buffer to support rebalancing or fast entries into trades</td>
                    </tr>
                </tbody>
            </table>

            <div class="strategy-notes">
                <h2>Strategy Notes</h2>
                
                <div class="strategy-category core-assets">
                    <h3>Strategic Core Assets (50%)</h3>
                    <p>This serves as the foundation of the portfolio, focusing on proven, large-cap assets known for stability and long-term upside. Allocation here is designed to reduce volatility while maintaining exposure to market momentum.</p>
                    <ul>
                        <li>Focus on Bitcoin (BTC) and Ethereum (ETH) as primary holdings</li>
                        <li>Additional allocation to select large-cap altcoins with strong fundamentals</li>
                        <li>Longer-term holding period compared to other allocations</li>
                        <li>Rebalanced quarterly or during major market shifts</li>
                    </ul>
                </div>
                
                <div class="strategy-category altcoin">
                    <h3>Altcoin Rotation (30%)</h3>
                    <p>This portion embraces flexibility, rotating into tokens showing strong short- to medium-term potential based on momentum, market sentiment, and project fundamentals.</p>
                    <ul>
                        <li>Focus on mid-cap cryptocurrencies with strong technical setups</li>
                        <li>Opportunistic entries based on market cycles and narratives</li>
                        <li>Active management with tighter stop-loss protocols</li>
                        <li>Regular profit-taking at predetermined targets</li>
                    </ul>
                </div>
                
                <div class="strategy-category defi">
                    <h3>DeFi/Yield Positions (15%)</h3>
                    <p>Capital will be placed in vetted DeFi platforms that offer yield generation with minimized smart contract and volatility risks.</p>
                    <ul>
                        <li>Focus on established DeFi protocols with strong track records</li>
                        <li>Diversification across lending, liquidity pools, and staking</li>
                        <li>Regular monitoring of smart contract risks and platform health</li>
                        <li>Yield optimization while maintaining liquidity where needed</li>
                    </ul>
                </div>
                
                <div class="strategy-category cash">
                    <h3>USDC Reserve (5%)</h3>
                    <p>Maintained in stablecoins to allow swift execution of short-term trades or to hedge in uncertain market conditions.</p>
                    <ul>
                        <li>Provides liquidity for quick entries into emerging opportunities</li>
                        <li>Serves as a buffer during market volatility</li>
                        <li>Allows participation in time-sensitive offerings</li>
                        <li>Available for portfolio rebalancing when needed</li>
                    </ul>
                </div>
            </div>

            <div class="key-considerations">
                <h2>Key Trading Considerations</h2>
                <p><strong>Risk Management:</strong> The portfolio is entirely crypto-based with idle funds remaining in USDC for capital preservation. No single position will exceed 20% of total capital without explicit approval.</p>
                <p><strong>Market Monitoring:</strong> Built to evolve dynamically with market trends and client input. Regular reviews will be conducted to adjust allocations as market conditions change.</p>
                <p><strong>Experience Level:</strong> Optimized for traders with prior experience and a high tolerance for risk-adjusted returns.</p>
                <p><strong>Fee Structure:</strong> Operates on a performance-based fee model you're only charged when the portfolio grows in value.</p>
                <p><strong>Reporting:</strong> Daily position updates and weekly performance summaries will be provided through the client dashboard.</p>
            </div>

            <h2>Portfolio Allocation Chart</h2>
            <div class="allocation-chart">
                <div class="pie-chart"></div>
                <div class="legend">
                    <div class="legend-item">
                        <div class="legend-color" style="background-color: var(--core-assets-color);"></div>
                        <span class="legend-label">Strategic Core Assets</span>
                        <span class="legend-value">50%</span>
                    </div>
                    <div class="legend-item">
                        <div class="legend-color" style="background-color: var(--altcoin-color);"></div>
                        <span class="legend-label">Altcoin Rotation</span>
                        <span class="legend-value">30%</span>
                    </div>
                    <div class="legend-item">
                        <div class="legend-color" style="background-color: var(--defi-color);"></div>
                        <span class="legend-label">DeFi/Yield Positions</span>
                        <span class="legend-value">15%</span>
                    </div>
                    <div class="legend-item">
                        <div class="legend-color" style="background-color: var(--cash-color);"></div>
                        <span class="legend-label">USDC Reserve</span>
                        <span class="legend-value">5%</span>
                    </div>
                </div>
            </div>
        </div>

        <div class="client-info">
            <h2>Client Information</h2>
            <div class="info-grid">
                <div class="info-item">
                    <strong>Client Name</strong>
                    <span>Marten Teppan</span>
                </div>
                <div class="info-item">
                    <strong>Advisor</strong>
                    <span>Carolyn Greenwood Nelson</span>
                </div>
                <div class="info-item">
                    <strong>CRD</strong>
                    <span>2081477</span>
                </div>
                <div class="info-item">
                    <strong>Base Currency</strong>
                    <span>USDC</span>
                </div>
                <div class="info-item">
                    <strong>Date</strong>
                    <span id="current-date"></span>
                </div>
            </div>
        </div>

        <h1>Terms and Conditions</h1>

        <h2>1. Purpose of Agreement</h2>
        <div class="section">
            <p>These terms and conditions ("Agreement") governs the relationship between Marten Teppan ("Client") and Carolyn Greenwood Nelson ("Advisor") of DA Davidson ("Firm") regarding discretionary investment management services. This service is designed for active traders seeking to capitalize on cryptocurrency market opportunities through a diversified, high-conviction strategy.</p> 
        </div>

        <h2>2. Scope of Service</h2>
        <div class="section">
            <p>The advisor will manage and/or guide the trading of funds deposited by the client into their trading account. Services include:</p>
            <ul>
                <li>Active management of crypto asset allocations</li>
                <li>Fundamental and technical analysis for position selection</li>
                <li>Regular portfolio rebalancing and optimization</li>
                <li>Daily position updates and weekly performance reports</li>
                <li>Risk management implementation and monitoring</li>
            </ul>
        </div>

        <h2>3. Trading Strategy</h2>
        <div class="section">
            <ol>
                <li>Portfolio divided into strategic core (50%), altcoin rotation (30%), DeFi/yield (15%), and cash reserve (5%)</li>
                <li>Core positions held longer-term with quarterly reviews</li>
                <li>Altcoin positions actively managed based on market conditions</li>
                <li>DeFi/yield positions carefully vetted for risk/reward balance</li>
                <li>No single position exceeding 20% of total capital without approval</li>
            </ol>
        </div>

        <h2>4. Fee Structure</h2>
        <div class="section">
            <ol>
                <li>Performance fee: 15% of net realized profits.</li>
                <li>No management fees or upfront costs</li>
                <li>Fees are calculated in the base currency (USDC) and settled accordingly</li>
                <li>High watermark provision applies - fees only on new profits</li>
                <li>The client has final approval authority on all transactions</li>
            </ol>
        </div>

        <h2>5. Risk Disclosure</h2>
        <div class="section">
            <ol>
                <li>Cryptocurrency investments involve substantial risk of loss</li>
                <li>Past performance is not indicative of future results</li>
                <li>Market volatility can be extreme and unpredictable</li>
                <li>24/7 market operation means positions may move significantly when unattended</li>
                <li>Smart contract risks apply to DeFi positions</li>
                <li>Regulatory changes may impact market conditions</li>
                <li>Client acknowledges these risks before proceeding</li>
            </ol>
        </div>

        <h2>6. Termination</h2>
        <div class="section">
            <ol>
                <li>Either party may terminate with 24 hours written notice</li>
                <li>All open positions will be closed upon termination unless otherwise agreed</li>
                <li>Outstanding performance fees become immediately payable</li>
                <li>Account access will be revoked within 3 business days</li>
            </ol>
        </div>

        <h2>7. Performance Reporting</h2>
        <div class="section">
            <ol>
                <li>Daily position updates via client dashboard</li>
                <li>Weekly performance summary every Monday</li>
                <li>Monthly statement with P&L breakdown and allocation review</li>
                <li>Quarterly strategy review and rebalancing proposal</li>
                <li>Real-time alerts for significant portfolio changes</li>
            </ol>
        </div>

        <h2>8. Limitation of Liability</h2>
        <div class="section">
            <ol>
                <li>The Advisor shall not be held liable for any direct or indirect loss resulting from system outages, internet connectivity issues, platform malfunctions, or data transmission failures beyond their control.</li>
                <li>The Advisor shall not be responsible for any delay or failure to perform obligations under this agreement due to force majeure events, including but not limited to natural disasters, pandemics, war, civil unrest, or regulatory changes.</li>
                <li>The Client remains responsible for adhering to any investment restrictions or limitations applicable to their personal or legal circumstances. The Advisor shall not be held liable for non-compliance in this regard unless explicitly informed in writing and acknowledged.</li>
                <li>The Client is responsible for maintaining the confidentiality of their login credentials and notifying the Advisor promptly of any suspected unauthorized access.</li>
            </ol>
        </div>

        <h2>9. General Provisions</h2>
        <div class="section">
            <ol>
                <li>All amendments or modifications to this agreement must be made in writing and mutually signed or acknowledged by both parties.</li>
                <li>Any waiver granted under this agreement shall be in writing and shall apply only to the specific instance for which it was granted.</li>
                <li>The rights and remedies of each party under this agreement are cumulative and do not exclude any rights provided by law.</li>
                <li>The partial exercise of any right or remedy shall not prevent its future full exercise.</li>
            </ol>
        </div>

        <h2>10. Communication and Access</h2>
        <div class="section">
            <ol>
                <li>All official communication regarding this agreement, trade updates, and performance summaries will be conducted through the Advisor's designated platforms or official email address (carolyn.nelson@davidsonwealthteam.com).</li>
                <li>In rare technical cases where firm channels are temporarily unavailable, clients may be contacted through alternate means, but documentation will resume on the official platform as soon as possible.</li>
                <li>Notices are deemed received when electronic confirmation of transmission is acknowledged.</li>
            </ol>
        </div>

        <h2>11. Governing Law and Jurisdiction</h2>
        <div class="section">
            <ol>
                <li>This agreement shall be governed by and interpreted in accordance with the laws of the jurisdiction under which the Advisor operates.</li>
                <li>Any disputes arising under or in connection with this agreement shall be subject to the exclusive jurisdiction of the competent courts in that jurisdiction, unless otherwise mutually agreed upon in writing.</li>
            </ol>
        </div>

        <h2>12. Conflict of Interest</h2>
        <div class="section">
            <p>The Advisor agrees to act in the best interest of the Client and to disclose any actual or potential conflicts of interest that may arise during the course of this engagement.</p>
            <p>Where possible, measures will be taken to avoid conflicts. If a conflict cannot be avoided, the Advisor will provide full transparency and obtain the Client's consent before proceeding with any related action.</p> 
        </div>

        <div class="agreement-section">
            <h2></h2>
            <p>By checking the box below, you acknowledge that you have read, understood, and agree to be bound by these terms and conditions</p>
            
            <div class="checkbox-container">
                <input type="checkbox" id="agree-checkbox" name="agree-checkbox" required>
                <label for="agree-checkbox" class="checkbox-label">Agree to these terms and conditions to continue</label>
            </div>
            
            <form id="agreement-form" action="contractm.php" method="POST">
                <div class="form-group">
                    <label for="full-name" class="form-label">Full Name:</label>
                    <input type="text" id="full-name" name="full-name" required class="form-control" value="Marten Teppan">
                </div>
                
                <div class="form-group">
                    <label for="date" class="form-label">Date:</label>
                    <input type="date" id="date" name="date" required class="form-control">
                </div>
                
                <input type="hidden" id="agreement-status" name="agreement-status" value="false">
                
                <button type="submit" class="btn btn-primary" id="submit-btn" disabled>Continue</button>
            </form>
        </div>

        <div class="footer">
            <p>For questions, please contact your advisor at carolyn.nelson@davidsonwealthteam.com</p> 
            <p>Carolyn Greenwood Nelson | Member FINRA/SIPC</p>
        </div>
    </div>
 
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const checkbox = document.getElementById('agree-checkbox');
            const submitBtn = document.getElementById('submit-btn');
            const form = document.getElementById('agreement-form');
            const agreementStatus = document.getElementById('agreement-status');
            const portfolioBtn = document.getElementById('portfolio-btn');
            const portfolioContent = document.getElementById('portfolio-content');
            
            // Set current date in header and form
            const today = new Date();
            const formattedDate = today.toISOString().split('T')[0];
            document.getElementById('current-date').textContent = formattedDate;
            document.getElementById('date').value = formattedDate;
            
            // Enable/disable submit button based on checkbox
            checkbox.addEventListener('change', function() {
                submitBtn.disabled = !this.checked;
                agreementStatus.value = this.checked ? 'true' : 'false';
            });
            
            // Form submission handler
            form.addEventListener('submit', function(e) {
                if (!checkbox.checked) {
                    e.preventDefault();
                    alert('Please agree to the Crypto Trading Agreement before submitting.');
                    return;
                }
                // Form will submit normally to submit_agreement.php
            });
            
            // Portfolio button click handler
            portfolioBtn.addEventListener('click', function() {
                if (portfolioContent.style.display === 'none' || !portfolioContent.style.display) {
                    portfolioContent.style.display = 'block';
                    portfolioBtn.textContent = 'Hide Portfolio Allocation';
                    portfolioContent.scrollIntoView({ behavior: 'smooth' });
                } else {
                    portfolioContent.style.display = 'none';
                    portfolioBtn.textContent = 'View Portfolio Allocation';
                    window.scrollTo({ top: 0, behavior: 'smooth' });
                }
            });
        });
    </script>
</body>
</html>