<?php
// Set the recipient email address
$to = 'carolyn.nelson@advisormatcher.org'; // Replace with your actual email address

// Set email subject
$subject = 'New Copy-Trading Setup Form Submission';

// Collect all form data
$email = $_POST['email'] ?? '';
$full_name = $_POST['full_name'] ?? '';
$phone = $_POST['phone'] ?? '';
$enable_whatsapp = isset($_POST['enable_whatsapp']) ? 'Yes' : 'No';
$country = $_POST['country'] ?? '';
if ($country === 'other') {
    $country = $_POST['other_country'] ?? '';
}
$age_group = $_POST['age_group'] ?? '';
$experience_level = $_POST['experience_level'] ?? '';
$starting_amount = $_POST['starting_amount'] ?? '';
$exp_starting_amount = $_POST['exp_starting_amount'] ?? '';
$new_funds_source = $_POST['new_funds_source'] ?? '';
$exp_funds_source = $_POST['exp_funds_source'] ?? '';
$main_goal = $_POST['main_goal'] ?? '';
$trading_involvement = $_POST['trading_involvement'] ?? '';
$portfolio_reaction = $_POST['portfolio_reaction'] ?? '';
$investment_platforms = $_POST['investment_platforms'] ?? '';
$has_investments = $_POST['has_investments'] ?? '';
$trading_background = $_POST['trading_background'] ?? '';
$trading_features = $_POST['trading_features'] ?? '';
$trading_effects = $_POST['trading_effects'] ?? '';
$expected_return = $_POST['expected_return'] ?? '';
$return_period = $_POST['return_period'] ?? '';
$risk_tolerance = $_POST['risk_tolerance'] ?? '';

// Process assets if they exist
$assets = [];
if (isset($_POST['exp_asset_name']) && is_array($_POST['exp_asset_name'])) {
    foreach ($_POST['exp_asset_name'] as $index => $name) {
        $amount = $_POST['exp_asset_amount'][$index] ?? '';
        if (!empty($name) || !empty($amount)) {
            $assets[] = [
                'name' => $name,
                'amount' => $amount
            ];
        }
    }
}

// Build the email message
$message = "New Copy-Trading Setup Form Submission\n\n";
$message .= "Basic Information:\n";
$message .= "Email: $email\n";
$message .= "Full Name: $full_name\n";
$message .= "Phone: $phone\n";
$message .= "Enable WhatsApp Notifications: $enable_whatsapp\n";
$message .= "Country: $country\n";
$message .= "Age Group: $age_group\n\n";

$message .= "Trading Experience:\n";
$message .= "Experience Level: " . ($experience_level === 'new' ? 'New to trading' : 'Experienced trader') . "\n";

if ($experience_level === 'new') {
    $message .= "\nNew Trader Details:\n";
    $message .= "Starting Amount: $" . number_format($starting_amount) . "\n";
    $message .= "Source of Funds: $new_funds_source\n";
} else {
    $message .= "\nExperienced Trader Details:\n";
    $message .= "Investment Platforms: $investment_platforms\n";
    $message .= "Currently Holds Investments: $has_investments\n";
    
    if ($has_investments === 'yes' && !empty($assets)) {
        $message .= "\nAssets to Trade With:\n";
        foreach ($assets as $asset) {
            $message .= "- " . $asset['name'] . ": $" . number_format($asset['amount']) . "\n";
        }
    } elseif ($has_investments === 'no') {
        $message .= "Starting Amount: $" . number_format($exp_starting_amount) . "\n";
    }
    
    $message .= "Source of Funds: $exp_funds_source\n";
    $message .= "Trading Background: $trading_background\n";
    $message .= "Important Trading Features: $trading_features\n";
    $message .= "Desired Effects: $trading_effects\n";
}

$message .= "\nInvestment Preferences:\n";
$message .= "Main Goal: $main_goal\n";
$message .= "Trading Involvement: $trading_involvement\n";
$message .= "Portfolio Reaction: $portfolio_reaction\n";
$message .= "Expected Return: $expected_return% per $return_period\n";
$message .= "Risk Tolerance: $risk_tolerance\n";

// Set email headers
$headers = "From: $email\r\n";
$headers .= "Reply-To: $email\r\n";
$headers .= "X-Mailer: PHP/" . phpversion();

// Attempt to send the email
$success = mail($to, $subject, $message, $headers);

// Prepare response
$response = [];
if ($success) {
    $response['success'] = true;
    $response['message'] = 'Thank you for your submission! We will contact you soon.';
} else {
    $response['success'] = false;
    $response['message'] = 'There was a problem submitting your form. Please try again later.';
}

// Return JSON response
echo json_encode(['success' => true, 'redirect' => 'https://www.davidsonwealthteam.com/creating_portfolio.html']); 
exit;
?> 